
<?php require __DIR__.'/require_login.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Flowpesa — Wallet</title>

  <!-- CSS + Icons -->
      <link rel="icon" href="assets/flowpesa-icon.png">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
  <div class="stage">
    <div class="title">Wallet</div>

    <div class="phone">
      <!-- Header / total balances -->
      <div class="hero wallet-hero">
        <small>Total Balance</small>
        <div class="amount" id="total">
          <span class="skel" style="display:inline-block;width:140px;height:40px;"></span>
        </div>
        <div class="wallet-stats">
          <div class="wallet-stat">
            <span class="label">Available</span>
            <span id="available" class="skel" style="height:25px; color:black ;"></span>
          </div>
          <div class="wallet-stat">
            <span class="label">Locked</span>
            <span id="locked" class="skel" style="height:25px; color:black ;"></span>
          </div>
          <div class="wallet-stat">
            <span class="label">Savings</span>
            <span id="savings" class="skel" style="height:25px; color:black ;"></span>
          </div>
        </div>
      </div>

      <div class="body">
        <!-- Filters / view controls -->
        <div class="filters mb-2">
          <div class="input-group input-group-sm">
            <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
            <input class="form-control" placeholder="Search SACCO or wallet"/>
          </div>
          <select class="form-select form-select-sm">
            <option value="all">All funds</option>
            <option value="wallet">Wallet only</option>
            <option value="sacco">SACCOs only</option>
          </select>
          <select class="form-select form-select-sm d-none d-md-block">
            <option value="month">This month</option>
            <option value="90">Last 90 days</option>
            <option value="year">This year</option>
          </select>
        </div>

        <!-- Wallet accounts overview -->
        <div class="section-title">
          <b>Wallet Accounts</b><a class="text-secondary small" href="#">Manage</a>
        </div>
        <div class="row g-2 mb-3">
          <div class="col-12">
            <div class="sacco-card d-flex justify-content-between align-items-center">
              <div>
                <div class="name">Main Wallet</div>
                <div class="meta">UGX • Instant transfers</div>
              </div>
              <div class="text-end">
                <div class="money" id="mainWallet">UGX 0</div>
                <div class="text-success small" id="walletDelta">+UGX 0 today</div>
              </div>
            </div>
          </div>
        </div>

        <!-- SACCOs -->
        <div class="section-title"><b>My SACCOs</b><a class="text-secondary small" href="#">See all →</a></div>
        <div id="saccos" class="row g-2"><!-- JS injects cards here --></div>

        <!-- Spend vs Save (summary) -->
        <div class="section-title mt-3"><b>Spend & Save Summary</b><a class="text-secondary small" href="#">Export</a></div>
        <div class="row g-2">
          <div class="col-6">
            <div class="sacco-card">
              <div class="name">This Month Saved</div>
              <div class="money" id="savedMonth">UGX 0</div>
              <div class="progress mt-2" role="progressbar" aria-label="Saved progress" aria-valuemin="0" aria-valuemax="100">
                <div id="savedBar" class="progress-bar bg-success" style="width:0%"></div>
              </div>
            </div>
          </div>
          <div class="col-6">
            <div class="sacco-card">
              <div class="name">This Month Spent</div>
              <div class="money" id="spentMonth">UGX 0</div>
              <div class="progress mt-2" role="progressbar" aria-label="Spent progress" aria-valuemin="0" aria-valuemax="100">
                <div id="spentBar" class="progress-bar bg-danger" style="width:0%"></div>
              </div>
            </div>
          </div>
        </div>

        <!-- Linked Accounts -->
        <div class="section-title mt-3"><b>Linked Accounts</b><a class="text-secondary small" href="#">Add</a></div>
        <div class="row g-2 mb-4">
          <div class="col-12">
            <div class="sacco-card d-flex align-items-center justify-content-between">
              <div class="d-flex align-items-center gap-2">
                <i class="bi bi-sim"></i>
                <div>
                  <div class="name">MTN Mobile Money</div>
                  <div class="meta">+256 700 000000</div>
                </div>
              </div>
              <button class="btn btn-sm btn-outline-dark"><i class="bi bi-cloud-arrow-down"></i> Sync</button>
            </div>
          </div>
        </div>
      </div>

      <nav class="nav">
        <a href="dashboard.php"><i class="bi bi-house"></i>Home</a>
        <a href="#"><i class="bi bi-receipt"></i>Bills</a>
        <a href="wallet.php" class="active"><i class="bi bi-wallet2"></i>Wallet</a>
        <a href="profile.php"><i class="bi bi-person-fill"></i>Profile</a>
      </nav>
    </div>
  </div>

  <!-- Page JS -->
   <script src="js/anim.js"></script>
  <script src="js/wallet.js" defer></script>
</body>
</html>
